/* AMX Mod script.
*
* (c) 2003, OLO
* This file is provided as is (no warranties).
*
* Content for configuation copied from ClanMod cfg. file.
* 
* Admin command:
* amx_mapmenu - displays maps menu
*
* Example configuration in addons/amx/config/maps.ini

as_oilrig   "OilRig - Assassination"
as_tundra   "Tundra - Assassination"
de_aztec    "Aztec - Bomb/Defuse"
de_cbble    "Cobble - Bomb/Defuse"
de_chateau    "Chateau - Bomb/Defuse"
de_dust     "Dust - Bomb/Defuse"
de_dust2    "Dust II - Bomb/Defuse"
de_inferno    "Inferno - Bomb/Defuse"
de_nuke     "Nuke - Bomb/Defuse"
de_prodigy    "Prodigy - Bomb/Defuse"
de_storm    "Storm - Bomb/Defuse"
de_survivor   "Survivor - Bomb/Defuse"
de_train    "Trainyard - Bomb/Defuse"
de_torn     "Torn - Bomb/Defuse"
de_vegas    "Vegas - Bomb/Defuse"
de_vertigo    "Vertigo - Bomb/Defuse"
cs_747      "747 Hijack - Hostage Rescue"
cs_assault    "Assault - Hostage Rescue"
cs_backalley  "Alleyway - Hostage Rescue"
cs_estate   "Zaphod's Estate - Hostage Rescue"
cs_havana   "Havana - Hostage Rescue"
cs_italy    "Italy - Hostage Rescue"
cs_militia    "Militia - Hostage Rescue"
cs_office   "The Office Complex - Hostage Rescue"
cs_siege    "Canyon Siege - Hostage Rescue"

*/

#include <translator>
#include <amxmod> 
#include <amxmisc> 

#define MAX_MAPS 64

new g_mapName[MAX_MAPS][32]
new g_mapDesc[MAX_MAPS][32]
new g_mapNums
new g_menuPosition[33]
new g_logFile[16]

new g_voteCount[5]

new g_voteSelected[33][4]
new g_voteSelectedNum[33]

new g_cstrikeRunning

new g_choosed

public plugin_init()
{
  load_translations("mapsmenu")
  register_plugin(_T("Maps Menu"),"0.9.9","default")
  register_clcmd("amx_mapmenu","cmdMapsMenu",ADMIN_MAP,_T("- displays changelevel menu"))
  register_clcmd("amx_votemapmenu","cmdVoteMapMenu",ADMIN_MAP,_T("- displays votemap menu"))

  register_menucmd(register_menuid("Changelevel Menu"),1023,"actionMapsMenu")
  register_menucmd(register_menuid("Which map do you want?"),527,"voteCount")
  register_menucmd(register_menuid("Change map to"),527,"voteCount")
  register_menucmd(register_menuid("Votemap Menu"),1023,"actionVoteMapMenu")
  register_menucmd(register_menuid("The winner: ") ,3,"actionResult")
  
  new filename[64]
  build_path( filename , 63 , "$basedir/config/maps.ini" )  
  load_settings( filename )

  get_logfile(g_logFile,15)
  
  g_cstrikeRunning = (is_running("cstrike") || is_running("czero"))
}

new g_resultAck[] = "Result accepted"
new g_resultRef[] = "Result refused"

public autoRefuse(){
  log_to_file(g_logFile,"Vote: %s" , g_resultRef)
  client_print(0,print_chat, _T(g_resultRef) )
}

public actionResult(id,key) {
  remove_task( 4545454  )
  switch(key){
    case 0: {
      message_begin(MSG_ALL, SVC_INTERMISSION)
      message_end()
      set_task(2.0,"delayedChange",0, g_mapName[  g_choosed  ] , strlen(g_mapName[  g_choosed  ]) + 1 )
      log_to_file(g_logFile,"Vote: %s" , g_resultAck )
      client_print(0,print_chat, _T(g_resultAck))
    }
    case 1: autoRefuse()
  }
  return PLUGIN_HANDLED
}

new g_voteSuccess[] = "Voting successful. Map will be changed to"
new g_VoteFailed[] = "Voting failed"

public checkVotes( id )
{
  id -= 34567
  new num, ppl[32],a = 0
  get_players(ppl,num,"c")
  if (num == 0) num = 1
  g_choosed = -1
  for(new i = 0; i < g_voteSelectedNum[id] ; ++i)
    if ( g_voteCount[a] < g_voteCount[i] )
      a = i
  if ( 100 * g_voteCount[a] / num >  50 )  {   
    g_choosed = g_voteSelected[id][a]
    client_print(0,print_chat, "%s %s" , _T(g_voteSuccess) , g_mapName[ g_choosed  ]  )
    log_to_file(g_logFile,"Vote: %s %s" , g_voteSuccess , g_mapName[ g_choosed  ] )
  }
  if ( g_choosed != -1 ) {  
    if ( is_user_connected( id ) )  {
      new menuBody[512]
      new len = format(menuBody,511,g_cstrikeRunning ? _T("\yThe winner: \w%s^n^n",id) :  _T("The winner: %s^n^n",id), g_mapName[ g_choosed  ] )
      len += copy( menuBody[len] ,511 - len, g_cstrikeRunning ? _T("\yDo you want to continue?^n\w",id) : _T("Do you want to continue?^n",id) )
      copy( menuBody[len] ,511 - len, _T("^n1. Yes^n2. No",id))
      show_menu( id  ,0x03 ,menuBody, 10,"The winner: " )
      set_task(10.0,"autoRefuse",4545454)
    }
    else  {
      message_begin(MSG_ALL, SVC_INTERMISSION)
      message_end()
      set_task(2.0,"delayedChange",0, g_mapName[  g_choosed  ] , strlen(g_mapName[  g_choosed  ]) + 1 )
    }
  }
  else {
    client_print(0,print_chat, _T(g_VoteFailed) )
    log_to_file(g_logFile,"Vote: %s" , g_VoteFailed)
  }
  remove_task(34567 + id)
}

public voteCount(id,key)
{
  if (key > 3) {
    client_print(0,print_chat,_T("Voting has been canceled"))
    remove_task(34567 + id)
    set_cvar_float( "amx_last_voting" , get_gametime()  )
    log_to_file(g_logFile,"Vote: Cancel vote session")
    return PLUGIN_HANDLED
  }
  if (get_cvar_float("amx_vote_answers")) {
    new name[32]
    get_user_name(id,name,31)
    client_print(0,print_chat,_T("%s voted for option #%d"), name , key + 1 )
  }
  ++g_voteCount[key]
  return PLUGIN_HANDLED
}

isMapSelected( id , pos )
{
  for( new a = 0 ; a < g_voteSelectedNum[ id ]; ++a )
    if ( g_voteSelected[ id ][ a ] == pos  )
      return 1
  return 0
}

displayVoteMapsMenu(id,pos)
{

  if (pos < 0)
    return

  new menuBody[512], b = 0 , start = pos * 7 
  
  if (start >= g_mapNums)
    start = pos = g_menuPosition[id] = 0
    
  new len = format(menuBody,511, g_cstrikeRunning ? 
    _T("\yVotemap Menu\R%d/%d^n\w^n",id) : _T("Votemap Menu %d/%d^n^n",id),
    pos+1,(  g_mapNums / 7 + (( g_mapNums % 7) ? 1 : 0 )) )

  new end = start + 7, keys = (1<<9)

  if (end > g_mapNums)
    end = g_mapNums

  for(new a = start; a < end; ++a)
  {  
    if ( g_voteSelectedNum[id]==4 || isMapSelected( id , pos * 7 + b ) )
    {
      ++b   
      if ( g_cstrikeRunning) 
        len += format(menuBody[len],511-len,"\d%d. %s^n\w",  b ,g_mapDesc[ a ])
      else
        len += format(menuBody[len],511-len,"#. %s^n",  g_mapDesc[ a ])
    }
    else
    {
      keys |= (1<<b)
      len += format(menuBody[len],511-len,"%d. %s^n",  ++b ,g_mapDesc[ a ])
    }
  }
  
  if ( g_voteSelectedNum[id] )
  {
    keys |= (1<<7)
    len += format(menuBody[len],511-len,_T("^n8. Start Voting^n",id))
  }
  else
    len += format(menuBody[len],511-len, g_cstrikeRunning ? 
      _T("^n\d8. Start Voting^n\w",id) : _T("^n#. Start Voting^n",id))
  
  if (end != g_mapNums)
  {
    len += format(menuBody[len],511-len,_T("^n9. More...^n0. %s^n",id), pos ? _T("Back",id) : _T("Exit",id))
    keys |= (1<<8)
  }
  else
    len += format(menuBody[len],511-len,"^n0. %s^n", pos ? _T("Back",id) : _T("Exit",id))
  
  len += format(menuBody[len],511-len, g_voteSelectedNum[id] ? 
    ( g_cstrikeRunning ? _T("^n\ySelected Maps:^n\w",id) : _T("^nSelected Maps:^n",id)) : _T("^n^n",id))

  for(new c = 0; c < 4; c++)
  {
    if ( c < g_voteSelectedNum[id] )
      len += format(menuBody[len],511-len,"%s^n", g_mapDesc[  g_voteSelected[id][ c ]  ] )
    else
      len += format(menuBody[len],511-len,"^n" )
  }

  show_menu(id,keys,menuBody,-1,"Votemap Menu")
}


public cmdVoteMapMenu(id,level,cid)
{
  if (!cmd_access(id,level,cid,1))
    return PLUGIN_HANDLED

  if ( get_cvar_float("amx_last_voting") > get_gametime() )
  {
    client_print(id,print_chat,_T("There is already one voting..."))
    return PLUGIN_HANDLED
  }
  
  g_voteSelectedNum[id] = 0
  
  if ( g_mapNums )
  {
    displayVoteMapsMenu(id,g_menuPosition[id] = 0)
  }
  else
  {
    console_print(id,_T("There are no maps in menu"))
    client_print(id,print_chat,_T("There are no maps in menu"))
  }

  return PLUGIN_HANDLED
}

public cmdMapsMenu(id,level,cid)
{
  if (!cmd_access(id,level,cid,1))
    return PLUGIN_HANDLED
  
  if ( g_mapNums )
  {
    displayMapsMenu(id,g_menuPosition[id] = 0)
  }
  else
  {
    console_print(id,_T("There are no maps in menu"))
    client_print(id,print_chat,_T("There are no maps in menu"))
  }
  
  return PLUGIN_HANDLED 
}

public delayedChange(mapname[])
  server_cmd("changelevel %s",mapname)


public actionVoteMapMenu(id,key)
{
  switch(key){
  case 7:{
  
      new Float:voting = get_cvar_float("amx_last_voting")
      if ( voting > get_gametime() ){ 
        client_print(id,print_chat,_T("There is already one voting...")) 
        return PLUGIN_HANDLED 
      } 
      if (voting && voting + get_cvar_float("amx_vote_delay") > get_gametime()) { 
        client_print(id,print_chat,_T("Voting not allowed at this time")) 
        return PLUGIN_HANDLED
      }
  
      g_voteCount = { 0 , 0 , 0 , 0 , 0 }
                    
      new Float:vote_time = get_cvar_float("amx_vote_time") + 2.0 
      set_cvar_float("amx_last_voting",  get_gametime() + vote_time )      
      new iVoteTime = floatround( vote_time )

      set_task( vote_time , "checkVotes",34567 + id)
      
      new menuBody[512]
      new players[32]
      new pnum, keys, len

      get_players(players,pnum)
      
      for(new b = 0; b < pnum; ++b){
        keys=0
        if ( g_voteSelectedNum[id] > 1 )
        {
          len = format(menuBody,511,g_cstrikeRunning ? 
            _T("\yWhich map do you want?^n\w^n",players[b]) : _T("Which map do you want?^n^n",players[b]))
          for(new c = 0; c < g_voteSelectedNum[id] ; ++c)
          {
            len += format(menuBody[len],511,"%d. %s^n", c + 1 , g_mapDesc[  g_voteSelected[id][ c ]  ] )
            keys |= (1<<c)
          }
          keys |= (1<<8)
          len += format(menuBody[len],511,_T("^n9. None^n",players[b]))
        }
        else
        {
          len = format(menuBody,511, g_cstrikeRunning ? _T("\yChange map to^n%s?^n\w^n1. Yes^n2. No^n",players[b])
            : _T("Change map to^n%s?^n^n1. Yes^n2. No^n",players[b]) , g_mapDesc[  g_voteSelected[id][ 0 ]  ] )
          keys = (1<<0) | (1<<1)
        }
      
        if ( players[b] != id )
          show_menu(players[b],keys,menuBody, iVoteTime, g_voteSelectedNum[id] > 1 ? "Which map do you want?" : "Change map to")
        else
        {
          format(menuBody[len],511,_T("^n0. Cancel Vote",id))
          keys |= (1<<9)
          show_menu(id,keys,menuBody, iVoteTime, g_voteSelectedNum[id] > 1 ? "Which map do you want?" : "Change map to")
        }
      }
      
      new authid[32],name[32]
      get_user_authid(id,authid,31)
      get_user_name(id,name,31)

      switch(get_cvar_num("amx_show_activity")) {
      case 2: client_print(0,print_chat,_T("ADMIN %s: vote map(s)"),name)
      case 1: client_print(0,print_chat,_T("ADMIN: vote map(s)"))
      }
      
      log_to_file(g_logFile,"Vote: ^"%s<%d><%s><>^" vote maps (map#1 ^"%s^") (map#2 ^"%s^") (map#3 ^"%s^") (map#4 ^"%s^")",
        name,get_user_userid(id),authid,
        g_voteSelectedNum[id] > 0 ? g_mapName[ g_voteSelected[id][ 0 ] ] : "" ,
        g_voteSelectedNum[id] > 1 ? g_mapName[ g_voteSelected[id][ 1 ] ] : "" ,
        g_voteSelectedNum[id] > 2 ? g_mapName[ g_voteSelected[id][ 2 ] ] : "",
        g_voteSelectedNum[id] > 3 ? g_mapName[ g_voteSelected[id][ 3 ] ] : "")
    }
  case 8: displayVoteMapsMenu(id,++g_menuPosition[id])
  case 9: displayVoteMapsMenu(id,--g_menuPosition[id])
  default: 
    {
      g_voteSelected[id][  g_voteSelectedNum[id]++  ] = g_menuPosition[id] * 7 + key
      
      displayVoteMapsMenu(id,g_menuPosition[id])
    }
  }
  return PLUGIN_HANDLED
}


public actionMapsMenu(id,key)
{
  switch(key){
  case 8: displayMapsMenu(id,++g_menuPosition[id])
  case 9: displayMapsMenu(id,--g_menuPosition[id])
  default: 
    {
      new a = g_menuPosition[id] * 8 + key
      
      message_begin(MSG_ALL, SVC_INTERMISSION)
      message_end()

      new authid[32],name[32]
      get_user_authid(id,authid,31)
      get_user_name(id,name,31)

      switch(get_cvar_num("amx_show_activity")) {
      case 2: client_print(0,print_chat,_T("ADMIN %s: changelevel %s"),name,g_mapName[  a  ])
      case 1: client_print(0,print_chat,_T("ADMIN: changelevel %s"),g_mapName[  a  ])
      }
      
      log_to_file(g_logFile,"Cmd: ^"%s<%d><%s><>^" changelevel ^"%s^"",
        name,get_user_userid(id),authid, g_mapName[  a  ] ) 
            
      set_task(2.0,"delayedChange",0, g_mapName[  a  ] , strlen(g_mapName[  a  ]) + 1 )
      
      /* displayMapsMenu(id,g_menuPosition[id]) */
    }
  }
  return PLUGIN_HANDLED
}

displayMapsMenu(id,pos)
{

  if (pos < 0)
    return

  new menuBody[512]
  new start = pos * 8 
  new b = 0
  
  if (start >= g_mapNums)
    start = pos = g_menuPosition[id] = 0
    
  new len = format(menuBody,511, g_cstrikeRunning ? 
    _T("\yChangelevel Menu\R%d/%d^n\w^n",id) : _T("Changelevel Menu %d/%d^n^n",id),
    pos+1,(  g_mapNums / 8 + (( g_mapNums % 8) ? 1 : 0 )) )
    
  new end = start + 8
  new keys = (1<<9)
  
  if (end > g_mapNums)
    end = g_mapNums
    
  for(new a = start; a < end; ++a)
  {   
    keys |= (1<<b)
    len += format(menuBody[len],511-len,"%d. %s^n",++b,g_mapDesc[ a ])
  }
  
  if (end != g_mapNums)
  {
    format(menuBody[len],511-len,_T("^n9. More...^n0. %s",id), pos ? _T("Back",id) : _T("Exit",id))
    keys |= (1<<8)
  }
  else format(menuBody[len],511-len,"^n0. %s", pos ? _T("Back",id) : _T("Exit",id))
 
  show_menu(id,keys,menuBody,-1,"Changelevel Menu")
}

load_settings(filename[])
{
  if (!file_exists(filename)) 
    return 0
    
  new text[256], szDesc[48]
  new a , pos = 0
  
  while ( g_mapNums < MAX_MAPS && read_file(filename,pos++,text,255,a) )
  {
    if ( text[0] == ';' ) continue
      
    if ( parse(text, g_mapName[g_mapNums] ,31, szDesc ,47) < 2 ) continue
    
    if ( !is_map_valid( g_mapName[g_mapNums] ) ) continue
          
    if ( strlen( szDesc ) > 31 )
    {
      copy(g_mapDesc[g_mapNums],28, szDesc )
      g_mapDesc[g_mapNums][28] = g_mapDesc[g_mapNums][29] = g_mapDesc[g_mapNums][30] = '.'
      g_mapDesc[g_mapNums][31] = 0
    }
    else copy(g_mapDesc[g_mapNums],31, szDesc )
            
    g_mapNums++
  }
  
  return 1
}
